﻿using System;
using System.Collections;

/// <summary>
///     Klasa używana przez mechanizm refleksji
/// </summary>
public class Reflected
{
    public int MyField;
    protected ArrayList myArray;

    public Reflected()
    {
        myArray = new ArrayList();
        myArray.Add("Jakiś element obiektu ArrayList");
    }

    public float MyProperty
    {
        get
        {
            return MyEvent();
        }
    }

    public object this[int index]
    {
        get
        {
            if (index <= myArray.Count)
            {
                return myArray[index];
            }
            else
            {
                return null;
            }
        }
        set
        {
            myArray.Add(value);
        }
    }

    public float MyInstanceMethod()
    {
        Console.WriteLine("Wywołanie metody instancyjnej MyInstanceMethod.");

        return 0.02f;
    }

    public static float MyStaticMethod()
    {
        Console.WriteLine("Wywołanie metody statycznej MyStaticMethod.");

        return 0.02f;
    }

    public delegate float MyDelegate();

    public event MyDelegate MyEvent
        = new MyDelegate(MyStaticMethod);

    public enum MyEnum { valOne, valTwo, valThree };
}
